/* <NAG_F77_lapack.h>
 *
 * Copyright 2000 Numerical Algorithms Group
 *
 * Include file for NAG C Library f07/f08 Chapters
 *
 * Mark 7
 */

  #define NAG_GRAPH_INCLUDED

  #if defined(NAG_WIN)
    /*
     * MICROSOFT 
     * Upper case, character string lengths follow the string parameter.
     */
/*    #include <pc32.h>  */

    #define f08aec_c(M, N, A, PDA, TAU, WORK, LWORK, INFO) \
    DGEQRF(M, N, A, PDA, TAU, WORK, LWORK, INFO)

    #define dorgqr_c(M, N, K, A, PDA, TAU, WORK, LWORK, INFO) \
    DORGQR(M, N, K, A, PDA, TAU, WORK, LWORK, INFO) 

    #define f06aaz_c(SRNAME, INFO, SRNAME_LEN) \
    F06AAZ(SRNAME, SRNAME_LEN, INFO)

    #define w06abz_c(NP, ME, M, N, IB, BBLK, A, LDA, B, LDB) \
    W06ABZ(NP, ME, M, N, IB, BBLK, A, LDA, B, LDB)

    #define w06baz_c(NP, ME, M, N, IB, BBLK, A, LDA, B, LDB) \
    W06BAZ(NP, ME, M, N, IB, BBLK, A, LDA, B, LDB)

    #define x02bhf_c() X02BHF()

    #define x02bjf_c() X02BJF()

    #define x02bkf_c() X02BKF()

    #define x02blf_c() X02BLF()

  #else
    /* UNIX 
     * lower case, underscore, string lengths are at the end of the
     * argument list 
     */
/*    #include <nagmk19_us.h>  */

    #define f08aec_c(M, N, A, PDA, TAU, WORK, LWORK, INFO) \
    dgeqrf_(M, N, A, PDA, TAU, WORK, LWORK, INFO)

    #define dorgqr_c(M, N, K, A, PDA, TAU, WORK, LWORK, INFO) \
    dorgqr_(M, N, K, A, PDA, TAU, WORK, LWORK, INFO) 

    #define f06aaz_c(SRNAME, INFO, SRNAME_LEN) \
    f06aaz_(SRNAME, INFO, SRNAME_LEN)

    #define w06abz_c(NP, ME, M, N, IB, BBLK, A, LDA, B, LDB) \
    w06abz_(NP, ME, M, N, IB, BBLK, A, LDA, B, LDB)

    #define w06baz_c(NP, ME, M, N, IB, BBLK, A, LDA, B, LDB) \
    w06baz_(NP, ME, M, N, IB, BBLK, A, LDA, B, LDB)

    #define x02bhf_c() x02bhf_()

    #define x02bjf_c() x02bjf_()

    #define x02bkf_c() x02bkf_()

    #define x02blf_c() x02blf_()

  #endif

